IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'PG_DEB_FORN_PG_CRED') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[PG_DEB_FORN_PG_CRED](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_DEB_FORN] [int] NOT NULL,
	[CD_PG_CRED] [int] NOT NULL,
 CONSTRAINT [PK_PG_DEB_FORN_PG_CRED] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_DEB_FORN] ASC,
	[CD_PG_CRED] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_CRED_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_CRED_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_CRED_CD_DEB_FORN]  DEFAULT ((0)) FOR [CD_DEB_FORN]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_CRED_CD_PG_CRED]  DEFAULT ((0)) FOR [CD_PG_CRED]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED]  WITH CHECK ADD  CONSTRAINT [FK_PG_DEB_FORN_PG_CRED_PG_CRED] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PG_CRED])
REFERENCES [dbo].[PG_CRED] ([CD_EMP], [CD_FILIAL], [CD_PG_CRED])

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED] CHECK CONSTRAINT [FK_PG_DEB_FORN_PG_CRED_PG_CRED]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED]  WITH CHECK ADD  CONSTRAINT [FK_PG_DEB_FORN_PG_CRED_PG_DEB_FORN] FOREIGN KEY([CD_EMP], [CD_DEB_FORN])
REFERENCES [dbo].[PG_DEB_FORN] ([CD_EMP], [CD_DEB_FORN])

ALTER TABLE [dbo].[PG_DEB_FORN_PG_CRED] CHECK CONSTRAINT [FK_PG_DEB_FORN_PG_CRED_PG_DEB_FORN]
end